/*
 * Decompiled with CFR 0.152.
 */
package io.github.jasonsimpart.createdelightcore.registry;

import com.github.alexmodguy.alexscaves.server.entity.item.ThrownIceCreamScoopEntity;
import com.github.alexmodguy.alexscaves.server.item.ThrownProjectileItem;
import com.tterrag.registrate.util.entry.ItemEntry;
import io.github.jasonsimpart.createdelightcore.content.item.ChocolateMoldFilledItem;
import io.github.jasonsimpart.createdelightcore.content.item.IceCreamItem;
import io.github.jasonsimpart.createdelightcore.content.item.MilkShakeItem;
import io.github.jasonsimpart.createdelightcore.registry.CDCreativeTabs;
import io.github.jasonsimpart.createdelightcore.registry.CDRegistration;
import io.github.jasonsimpart.createdelightcore.registry.CDTags;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import org.forsteri.ratatouille.entry.CRCreativeModeTabs;

public class CDItems {
    public static final ResourceKey<CreativeModeTab> MISC_TAB = CDCreativeTabs.MISC.getKey();
    public static final ResourceKey<CreativeModeTab> COIN_TAB = CDCreativeTabs.COIN.getKey();
    public static final ResourceKey<CreativeModeTab> RATATOUILLE_TAB = CRCreativeModeTabs.BASE_CREATIVE_TAB.getKey();
    public static final ResourceKey<CreativeModeTab> FOOD_TAB = CDCreativeTabs.FOOD.getKey();
    public static final ItemEntry<Item> UNFRIED_SHRIMP = CDItems.simpleRawFood("unfried_shrimp", 4, 0.3f);
    public static final ItemEntry<Item> UNFRIED_CHICKEN_CHIP = CDItems.simpleRawFood("unfried_chicken_chip", 2, 0.3f);
    public static final ItemEntry<Item> UNFRIED_CHICKEN_LEG = CDItems.simpleRawFood("unfried_chicken_leg", 2, 0.3f);
    public static final ItemEntry<Item> UNFRIED_TONKATSU = CDItems.simpleRawFood("unfried_tonkatsu", 4, 0.3f);
    public static final ItemEntry<Item> UNFRIED_FISH = CDItems.simpleRawFood("unfried_fish", 3, 0.3f);
    public static final ItemEntry<Item> UNFRIED_POTATO = CDItems.simpleRawFood("unfried_potato", 2, 0.3f);
    public static final ItemEntry<Item> UNFRIED_CALAMARI = CDItems.simpleRawFood("unfried_calamari", 1, 0.3f);
    public static final ItemEntry<ThrownProjectileItem> STRAWBERRY_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("strawberry");
    public static final ItemEntry<ThrownProjectileItem> BANANA_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("banana");
    public static final ItemEntry<ThrownProjectileItem> MINT_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("mint");
    public static final ItemEntry<ThrownProjectileItem> ADZUKI_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("adzuki");
    public static final ItemEntry<ThrownProjectileItem> POMEGRANATE_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("pomegranate");
    public static final ItemEntry<ThrownProjectileItem> LIME_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("lime");
    public static final ItemEntry<ThrownProjectileItem> APPLE_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("apple");
    public static final ItemEntry<ThrownProjectileItem> BEETROOT_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("beetroot");
    public static final ItemEntry<ThrownProjectileItem> CARROT_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("carrot");
    public static final ItemEntry<ThrownProjectileItem> ENHANCED_FRUIT_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("enhanced_fruit");
    public static final ItemEntry<ThrownProjectileItem> GLOW_BERRY_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("glow_berry");
    public static final ItemEntry<ThrownProjectileItem> PUMPKIN_ICE_CREAM_SCOOP = CDItems.iceCreamScoop("pumpkin");
    public static final ItemEntry<Item> BLACK_CHOCOLATE_MOLD_SOLID = CDItems.simpleItem("black_chocolate_mold_solid", RATATOUILLE_TAB);
    public static final ItemEntry<ChocolateMoldFilledItem> BLACK_CHOCOLATE_MOLD_FILLED;
    public static final ItemEntry<Item> WHITE_CHOCOLATE_MOLD_SOLID;
    public static final ItemEntry<ChocolateMoldFilledItem> WHITE_CHOCOLATE_MOLD_FILLED;
    public static final ItemEntry<Item> RUBY_CHOCOLATE_MOLD_SOLID;
    public static final ItemEntry<ChocolateMoldFilledItem> RUBY_CHOCOLATE_MOLD_FILLED;
    public static final ItemEntry<Item> IRON;
    public static final ItemEntry<Item> COPPER;
    public static final ItemEntry<Item> GOLD;
    public static final ItemEntry<Item> EMERALD;
    public static final ItemEntry<Item> NETHERITE;
    public static final ItemEntry<Item> TIN_INGOT;
    public static final ItemEntry<Item> TIN_NUGGET;
    public static final ItemEntry<Item> RAW_TIN;
    public static final ItemEntry<Item> BRONZE_INGOT;
    public static final ItemEntry<Item> BRONZE_NUGGET;

    public static ItemEntry<IceCreamItem> iceCreamItem(String name, int nutrition, float saturation) {
        return CDRegistration.REGISTRATE.item(name + "_ice_cream", IceCreamItem::new).properties(p -> p.m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38767_()).m_41495_(Items.f_42399_).m_41487_(1)).tab(FOOD_TAB).register();
    }

    public static ItemEntry<MilkShakeItem> milkShakeItem(String name, int nutrition, float saturation) {
        return CDRegistration.REGISTRATE.item(name + "_milkshake", MilkShakeItem::new).properties(p -> p.m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38767_()).m_41495_(Items.f_42590_).m_41487_(16)).tab(FOOD_TAB).register();
    }

    public static ItemEntry<ThrownProjectileItem> iceCreamScoop(String name) {
        return CDRegistration.REGISTRATE.item(name + "_ice_cream_scoop", properties -> new ThrownProjectileItem(properties, player -> new ThrownIceCreamScoopEntity(player.m_9236_(), (LivingEntity)player), -10.0f, 1.0f, 0.2f)).tab(FOOD_TAB).register();
    }

    public static ItemEntry<Item> simpleFood(String name, int nutrition, float saturation) {
        return CDRegistration.REGISTRATE.item(name, Item::new).properties(p -> p.m_41489_(new FoodProperties.Builder().m_38760_(nutrition).m_38758_(saturation).m_38767_())).tab(FOOD_TAB).register();
    }

    public static ItemEntry<Item> simpleRawFood(String name, int nutrition, float saturation) {
        return CDRegistration.REGISTRATE.item(name, Item::new).properties(p -> p.m_41489_(new FoodProperties.Builder().m_38762_(new MobEffectInstance(MobEffects.f_19612_, 50, 0, false, false), 0.5f).m_38760_(nutrition).m_38758_(saturation).m_38767_())).tab(FOOD_TAB).register();
    }

    public static ItemEntry<Item> simpleItem(String name) {
        return CDItems.simpleItem(name, MISC_TAB);
    }

    public static ItemEntry<Item> simpleItem(String name, ResourceKey<CreativeModeTab> tab) {
        return CDItems.simpleItem(name, tab, Rarity.COMMON);
    }

    public static ItemEntry<Item> simpleItem(String name, ResourceKey<CreativeModeTab> tab, Rarity rarity) {
        return CDRegistration.REGISTRATE.item(name, Item::new).properties(properties -> properties.m_41497_(rarity)).tab(tab).register();
    }

    public static ItemEntry<Item> coinItem(String coinTier, Rarity rarity) {
        return CDRegistration.REGISTRATE.item(coinTier + "_coin", Item::new).properties(properties -> properties.m_41497_(rarity).m_41486_()).tab(COIN_TAB).register();
    }

    public static ItemEntry<Item> simpleIngot(String metalName) {
        return CDRegistration.REGISTRATE.item(metalName + "_ingot", Item::new).tag(new TagKey[]{CDTags.forgeItemTag("ingots/" + metalName), CDTags.forgeItemTag("ingots")}).tab(MISC_TAB).register();
    }

    public static ItemEntry<Item> simpleNugget(String metalName) {
        return CDRegistration.REGISTRATE.item(metalName + "_nugget", Item::new).tag(new TagKey[]{CDTags.forgeItemTag("nuggets/" + metalName), CDTags.forgeItemTag("nuggets")}).tab(MISC_TAB).register();
    }

    public static ItemEntry<Item> simpleRawMaterial(String metalName) {
        return CDRegistration.REGISTRATE.item("raw_" + metalName, Item::new).tag(new TagKey[]{CDTags.forgeItemTag("raw_materials/" + metalName), CDTags.forgeItemTag("raw_materials")}).tab(MISC_TAB).register();
    }

    public static void init() {
    }

    static {
        WHITE_CHOCOLATE_MOLD_SOLID = CDItems.simpleItem("white_chocolate_mold_solid", RATATOUILLE_TAB);
        RUBY_CHOCOLATE_MOLD_SOLID = CDItems.simpleItem("ruby_chocolate_mold_solid", RATATOUILLE_TAB);
        BLACK_CHOCOLATE_MOLD_FILLED = CDRegistration.REGISTRATE.item("black_chocolate_mold_filled", properties -> new ChocolateMoldFilledItem((Item.Properties)properties, new ItemStack((ItemLike)BLACK_CHOCOLATE_MOLD_SOLID.get()))).tab(RATATOUILLE_TAB).register();
        WHITE_CHOCOLATE_MOLD_FILLED = CDRegistration.REGISTRATE.item("white_chocolate_mold_filled", properties -> new ChocolateMoldFilledItem((Item.Properties)properties, new ItemStack((ItemLike)WHITE_CHOCOLATE_MOLD_SOLID.get()))).tab(RATATOUILLE_TAB).register();
        RUBY_CHOCOLATE_MOLD_FILLED = CDRegistration.REGISTRATE.item("ruby_chocolate_mold_filled", properties -> new ChocolateMoldFilledItem((Item.Properties)properties, new ItemStack((ItemLike)RUBY_CHOCOLATE_MOLD_SOLID.get()))).tab(RATATOUILLE_TAB).register();
        IRON = CDItems.coinItem("iron", Rarity.COMMON);
        COPPER = CDItems.coinItem("copper", Rarity.UNCOMMON);
        GOLD = CDItems.coinItem("gold", Rarity.RARE);
        EMERALD = CDItems.coinItem("emerald", Rarity.RARE);
        NETHERITE = CDItems.coinItem("netherite", Rarity.EPIC);
        RAW_TIN = CDItems.simpleRawMaterial("tin");
        TIN_INGOT = CDItems.simpleIngot("tin");
        TIN_NUGGET = CDItems.simpleNugget("tin");
        BRONZE_INGOT = CDItems.simpleIngot("bronze");
        BRONZE_NUGGET = CDItems.simpleNugget("bronze");
    }
}

